IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE NAME ='V_VENDAS_CONV_SEM_VINC_CANCELADAS')
	DROP VIEW [DBO].[V_VENDAS_CONV_SEM_VINC_CANCELADAS]
GO

    
CREATE VIEW [DBO].[V_VENDAS_CONV_SEM_VINC_CANCELADAS]
AS
SELECT C.CD_EMP
	,C.CD_FILIAL
	,C.CD_CX
	,C.NR_ECF
	,C.CD_CLI
	,CLI.RZ_CLI
	,C.DT_VD
	,C.VLR_CONV
	,CASE 
		WHEN C.ST_FECHVD_CONV = 0
			THEN 'ABERTO'
		WHEN C.ST_FECHVD_CONV = 1
			THEN 'FECHADA'
		WHEN C.ST_FECHVD_CONV = 2
			THEN 'CANCELADA'
		WHEN C.ST_FECHVD_CONV = 3
			THEN 'AMORTIZADA'
		WHEN C.ST_FECHVD_CONV = 4
			THEN 'DEVOLVIDA'
		WHEN C.ST_FECHVD_CONV = 5
			THEN 'AGD.FECHAMENTO'
		WHEN C.ST_FECHVD_CONV = 6
			THEN 'GLOSA/PERDA CRÉDITO'
		END AS STATUS_CONVENIO
	,CASE 
		WHEN V.CD_VD IS NULL
			THEN '0 - SEM CUPOM FISCAL'
		WHEN V.CD_VD > 0
			AND V.ST_VD = 1
			THEN '1 - CUPOM FISCAL CANCELADO'
		END AS SITUACAO_CUPOM
	,CASE 
		WHEN V.CD_VD IS NULL
			THEN 0
		WHEN V.CD_VD > 0
			AND V.ST_VD = 1
			THEN 1
		END AS SITUACAO
	,ISNULL(C.CD_CTR, 0) AS CD_CTR
	,0 AS CD_VD
FROM RC_VD_CONV C
LEFT JOIN PDV_VD V ON C.CD_EMP = V.CD_EMP
	AND C.CD_FILIAL = V.CD_FILIAL
	AND C.DT_VD = V.DT_VD
	AND C.NR_ECF = V.NR_ECF
	AND C.CD_CX = V.CD_CX
INNER JOIN RC_CLI CLI ON CLI.CD_EMP = C.CD_EMP
	AND CLI.CD_CLI = C.CD_CLI
LEFT JOIN PDV_VD_RC_VD_CONV VINC ON VINC.CD_EMP = C.CD_EMP
	AND VINC.CD_FILIAL = C.CD_FILIAL
	AND VINC.CD_CTR = C.CD_CTR
WHERE V.ST_VD = 1
	AND V.VLR_CONV > 0
	AND VINC.CD_CTR > 0
	AND C.ST_FECHVD_CONV IN (0, 1, 5)

UNION ALL

SELECT C.CD_EMP
	,C.CD_FILIAL
	,C.CD_CX
	,C.NR_ECF
	,C.CD_CLI
	,CLI.RZ_CLI
	,C.DT_VD
	,C.VLR_CONV
	,CASE 
		WHEN C.ST_FECHVD_CONV = 0
			THEN 'ABERTO'
		WHEN C.ST_FECHVD_CONV = 1
			THEN 'FECHADA'
		WHEN C.ST_FECHVD_CONV = 2
			THEN 'CANCELADA'
		WHEN C.ST_FECHVD_CONV = 3
			THEN 'AMORTIZADA'
		WHEN C.ST_FECHVD_CONV = 4
			THEN 'DEVOLVIDA'
		WHEN C.ST_FECHVD_CONV = 5
			THEN 'AGD.FECHAMENTO'
		WHEN C.ST_FECHVD_CONV = 6
			THEN 'GLOSA/PERDA CRÉDITO'
		END AS STATUS_CONVENIO
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN '0 - SEM CUPOM FISCAL'
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN '1 - CUPOM FISCAL CANCELADO'
			END, '') AS SITUACAO_CUPOM
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN 0
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN 1
			END, 0) AS SITUACAO
	,ISNULL(C.CD_CTR, 0) AS CD_CTR
	,0 AS CD_VD
FROM RC_VD_CONV C
LEFT JOIN PDV_VD V ON C.CD_EMP = V.CD_EMP
	AND C.CD_FILIAL = V.CD_FILIAL
	AND C.DT_VD = V.DT_VD
	AND C.NR_ECF = V.NR_ECF
	AND C.CD_CX = V.CD_CX
INNER JOIN RC_CLI CLI ON CLI.CD_EMP = C.CD_EMP
	AND CLI.CD_CLI = C.CD_CLI
LEFT JOIN PDV_VD_RC_VD_CONV VINC ON VINC.CD_EMP = C.CD_EMP
	AND VINC.CD_FILIAL = C.CD_FILIAL
	AND VINC.CD_CTR = C.CD_CTR
WHERE V.ST_VD = 0 
	AND V.VLR_CONV = 0
	AND VINC.CD_CTR > 0
	AND C.ST_FECHVD_CONV IN (0, 1, 5)

UNION ALL

SELECT C.CD_EMP
	,C.CD_FILIAL
	,C.CD_CX
	,C.NR_ECF
	,C.CD_CLI
	,CLI.RZ_CLI
	,C.DT_VD
	,C.VLR_CONV
	,CASE 
		WHEN C.ST_FECHVD_CONV = 0
			THEN 'ABERTO'
		WHEN C.ST_FECHVD_CONV = 1
			THEN 'FECHADA'
		WHEN C.ST_FECHVD_CONV = 2
			THEN 'CANCELADA'
		WHEN C.ST_FECHVD_CONV = 3
			THEN 'AMORTIZADA'
		WHEN C.ST_FECHVD_CONV = 4
			THEN 'DEVOLVIDA'
		WHEN C.ST_FECHVD_CONV = 5
			THEN 'AGD.FECHAMENTO'
		WHEN C.ST_FECHVD_CONV = 6
			THEN 'GLOSA/PERDA CRÉDITO'
		END AS STATUS_CONVENIO
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN '0 - SEM CUPOM FISCAL'
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN '1 - CUPOM FISCAL CANCELADO'
			END, '') AS SITUACAO_CUPOM
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN 0
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN 1
			END, 0) AS SITUACAO
	,ISNULL(C.CD_CTR, 0) AS CD_CTR
	,0 AS CD_VD
FROM RC_VD_CONV C
LEFT JOIN PDV_VD V ON C.CD_EMP = V.CD_EMP
	AND C.CD_FILIAL = V.CD_FILIAL
	AND C.DT_VD = V.DT_VD
	AND C.NR_ECF = V.NR_ECF
	AND C.CD_CX = V.CD_CX
INNER JOIN RC_CLI CLI ON CLI.CD_EMP = C.CD_EMP
	AND CLI.CD_CLI = C.CD_CLI
LEFT JOIN PDV_VD_RC_VD_CONV VINC ON VINC.CD_EMP = C.CD_EMP
	AND VINC.CD_FILIAL = C.CD_FILIAL
	AND VINC.CD_CTR = C.CD_CTR
WHERE V.CD_VD IS NULL
	AND V.VLR_CONV > 0
	AND VINC.CD_CTR > 0
	AND C.ST_FECHVD_CONV IN (0, 1, 5)

UNION ALL

SELECT C.CD_EMP
	,C.CD_FILIAL
	,C.CD_CX
	,C.NR_ECF
	,C.CD_CLI
	,CLI.RZ_CLI
	,C.DT_VD
	,C.VLR_CONV
	,CASE 
		WHEN C.ST_FECHVD_CONV = 0
			THEN 'ABERTO'
		WHEN C.ST_FECHVD_CONV = 1
			THEN 'FECHADA'
		WHEN C.ST_FECHVD_CONV = 2
			THEN 'CANCELADA'
		WHEN C.ST_FECHVD_CONV = 3
			THEN 'AMORTIZADA'
		WHEN C.ST_FECHVD_CONV = 4
			THEN 'DEVOLVIDA'
		WHEN C.ST_FECHVD_CONV = 5
			THEN 'AGD.FECHAMENTO'
		WHEN C.ST_FECHVD_CONV = 6
			THEN 'GLOSA/PERDA CRÉDITO'
		END AS STATUS_CONVENIO
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN '0 - SEM CUPOM FISCAL'
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN '1 - CUPOM FISCAL CANCELADO'
			END, '') AS SITUACAO_CUPOM
	,ISNULL(CASE 
			WHEN V.CD_VD IS NULL
				THEN 0
			WHEN V.CD_VD > 0
				AND V.ST_VD = 1
				THEN 1
			END, 0) AS SITUACAO
	,ISNULL(C.CD_CTR, 0) AS CD_CTR
	,0 AS CD_VD
FROM RC_VD_CONV C
LEFT JOIN PDV_VD V ON C.CD_EMP = V.CD_EMP
	AND C.CD_FILIAL = V.CD_FILIAL
	AND C.DT_VD = V.DT_VD
	AND C.NR_ECF = V.NR_ECF
	AND C.CD_CX = V.CD_CX
INNER JOIN RC_CLI CLI ON CLI.CD_EMP = C.CD_EMP
	AND CLI.CD_CLI = C.CD_CLI
LEFT JOIN PDV_VD_RC_VD_CONV VINC ON VINC.CD_EMP = C.CD_EMP
	AND VINC.CD_FILIAL = C.CD_FILIAL
	AND VINC.CD_CTR = C.CD_CTR
WHERE V.CD_VD IS NULL
	AND V.VLR_CONV > 0
	AND ISNULL(VINC.CD_CTR, 0) = 0
	AND C.ST_FECHVD_CONV IN (0, 1, 5)


  
    
    
    